const express = require('express')
const app = express()
const {pool} = require('../connection/connection')




const fetchNotification = async (req, res) => {
  const db = await pool;

  try {
    const { uid } = req.user;

    if (!uid) {
      return res.status(400).json({ message: "UID not found in cookies" });
    }

    // Sanitize the schema name to prevent SQL injection
    const schema = `db${uid}`;
    
    const query=`SELECT * FROM ${schema}.useralerts WHERE loginid=? ORDER BY ctime DESC`

    
    const [Execute]=await db.query(query,[uid])
    // console.log(Execute,"ASd")
    
    if(Execute.length<0){
        res.status(404).json({msg:"No new notification"})
        return
    }
    res.status(200).json({noti:Execute})


}catch(error){
    console.log(error)
    res.status(501)
}
}


const updateReadFlag = async (req, res) => {
  const db = await pool;

  try {
    const { uid } = req.user;
    const { ids } = req.body; 

    if (!uid) {
      return res.status(400).json({ message: "UID not found in cookies" });
    }

    if (!Array.isArray(ids) || ids.length === 0) {
      return res.status(400).json({ message: "Invalid or empty ID list" });
    }

    const schema = `db${uid}`;
    const placeholders = ids.map(() => '?').join(',');
    const query = `UPDATE ${schema}.useralerts SET readflag = 1 WHERE id IN (${placeholders})`;

    await db.query(query, ids);
    res.status(200).json({ message: "Read flags updated successfully" });

  } catch (error) {
    console.error(error);
    res.status(500).json({ message: "Internal server error" });
  } 
};



const deleteAllNotifications = async (req, res) => {
  const db = await pool;

  try {
    const { uid } = req.user;

    if (!uid) {
      return res.status(400).json({ message: "UID not found in cookies" });
    }

    const schema = `db${uid}`;
    const query = `DELETE FROM ${schema}.useralerts `;

    await db.query(query, [uid]);
    res.status(200).json({ message: "All notifications deleted" });

  } catch (error) {
    console.error(error);
    res.status(500).json({ message: "Internal server error" });
  }
};



module.exports={fetchNotification,updateReadFlag,deleteAllNotifications}