const fs = require('fs');
const path = require('path');

// Log file path
const logFile = path.join(__dirname, '../log/app.log');

// Logger function
function log(message, level = 'INFO') {
  const timestamp = new Date().toLocaleString().toString();
  const logMessage = `[${timestamp}] [${level.toUpperCase()}]: ${message}\n`;

  fs.appendFile(logFile, logMessage, (err) => {
    if (err) {
      console.error('Failed to write to log file:', err);
    }
  });
}

module.exports = {
  log,
};
