// // // // const axios = require("axios");
// // // // const fs = require("fs");
// // // // const path = require("path");

// // // // async function downloadZipStream(url, outputFile = "output.zip") {
// // // //   try {
// // // //     const response = await axios({
// // // //       method: "GET",
// // // //       url,
// // // //       responseType: "stream", // 👈 key: stream, not arraybuffer
// // // //       headers: {
// // // //         "Accept": "*/*",
// // // //         "Connection": "keep-alive",
// // // //       },
// // // //     });

// // // //     const writer = fs.createWriteStream(outputFile);

// // // //     // Pipe the streaming response directly to file
// // // //     response.data.pipe(writer);

// // // //     // Handle completion
// // // //     await new Promise((resolve, reject) => {
// // // //       writer.on("finish", resolve);
// // // //       writer.on("error", reject);
// // // //     });

// // // //     console.log(`✅ ZIP downloaded as ${outputFile}`);
// // // //     return outputFile;
// // // //   } catch (err) {
// // // //     console.error("❌ Error downloading stream:", err.message);
// // // //   }
// // // // }

// // // // // Example usage
// // // // (async () => {
// // // //   const url = "http://103.148.165.134:5006/api/Home/GetImage?lid=7&uid=11&date=2025-08-12";
// // // //   await downloadZipStream(url, path.join(__dirname, "streamed.zip"));
// // // // })();


// // // const express = require("express");
// // // const axios = require("axios");

// // // const app = express();

// // // app.get("/proxy-zip", async (req, res) => {
// // //   try {
// // //     const url = "http://103.148.165.134:5006/api/Home/GetImage?lid=7&uid=11&date=2025-08-12";

// // //     // Start streaming request
// // //     const response = await axios({
// // //       method: "GET",
// // //       url,
// // //       responseType: "stream",
// // //       headers: {
// // //         "Accept": "*/*",
// // //         "Connection": "keep-alive",
// // //       },
// // //     });

// // //     // Pass headers from source (important for zip mime type)
// // //     res.setHeader("Content-Type", response.headers["content-type"] || "application/zip");
// // //     res.setHeader("Content-Disposition", 'attachment; filename="proxy.zip"');

// // //     // Pipe the zip stream directly to client
// // //     response.data.pipe(res);

// // //     // Handle errors
// // //     response.data.on("error", (err) => {
// // //       console.error("Error in streaming:", err.message);
// // //       res.end();
// // //     });

// // //   } catch (err) {
// // //     console.error("❌ Proxy stream error:", err.message);
// // //     res.status(500).send("Stream failed");
// // //   }
// // // });

// // // app.listen(3000, () => {
// // //   console.log("Server running at http://localhost:3000/proxy-zip");
// // // });






// // const express = require("express");
// // const axios = require("axios");
// // const unzipper = require("unzipper");

// // const app = express();

// // app.get("/list-zip", async (req, res) => {
// //   try {
// //     const url = "http://103.148.165.134:5006/api/Home/GetImage?lid=7&uid=11&date=2025-08-12";

// //     const response = await axios({
// //       method: "GET",
// //       url,
// //       responseType: "stream"
// //     });

// //     const fileList = [];

// //     response.data
// //       .pipe(unzipper.Parse())
// //       .on("entry", (entry) => {
// //         fileList.push({
// //           fileName: entry.path,
// //           size: entry.vars.uncompressedSize,
// //           type: entry.type // 'File' or 'Directory'
// //         });
// //         entry.autodrain(); // don’t save, just read metadata
// //       })
// //       .on("close", () => {
// //         res.json(fileList); // send list back to client
// //       });

// //   } catch (err) {
// //     console.error("❌ Error listing zip:", err.message);
// //     res.status(500).send("Failed to read zip");
// //   }
// // });

// // app.listen(3000, () => console.log("http://localhost:3000/list-zip"));





// const express = require("express");
// const axios = require("axios");
// const cores=require('cors')
// const unzipper = require("unzipper");

// const app = express();
// app.use(cores())
// const ZIP_URL = "http://103.148.165.134:5006/api/Home/GetImage?lid=7&uid=11&date=2025-08-12";

// // 1. List files inside the zip
// app.get("/list-zip", async (req, res) => {
//   try {
//     const response = await axios({ method: "GET", url: ZIP_URL, responseType: "stream" });
//     const fileList = [];

//     response.data
//       .pipe(unzipper.Parse())
//       .on("entry", (entry) => {
//         if (entry.type === "File") {
//           fileList.push(entry.path);
//         }
//         entry.autodrain();
//       })
//       .on("close", () => {
//         res.json(fileList);
//       });
//   } catch (err) {
//     console.error("❌ Error:", err.message);
//     res.status(500).send("Failed to read zip");
//   }
// });

// // 2. Stream individual files from zip
// app.get("/file-from-zip/:filename", async (req, res) => {
//   try {
//     const targetFile = decodeURIComponent(req.params.filename);

//     const response = await axios({ method: "GET", url: ZIP_URL, responseType: "stream" });

//     let found = false;
//     response.data.pipe(unzipper.Parse())
//       .on("entry", (entry) => {
//         if (entry.path === targetFile) {
//           found = true;
//           res.setHeader("Content-Type", "image/jpeg"); // or detect dynamically
//           entry.pipe(res);
//         } else {
//           entry.autodrain();
//         }
//       })
//       .on("close", () => {
//         if (!found) res.status(404).send("File not found in zip");
//       });

//   } catch (err) {
//     console.error("❌ Error streaming file:", err.message);
//     res.status(500).send("Failed to extract file");
//   }
// });

// app.listen(3000, () => console.log("✅ Server at http://localhost:3000"));








const express = require("express");
const axios = require("axios");
const cors = require('cors');
const unzipper = require("unzipper");
const fs = require('fs');
const path = require('path');

const app = express();
app.use(cors());

const ZIP_URL = "http://103.148.165.134:5006/api/Home/GetImage?lid=7&uid=11&date=2025-08-12";

// Download and save ZIP file for inspection
app.get("/download-zip", async (req, res) => {
  try {
    console.log("📥 Downloading ZIP file...");
    
    const response = await axios({
      method: "GET",
      url: ZIP_URL,
      responseType: "arraybuffer",
      timeout: 30000
    });

    const buffer = Buffer.from(response.data);
    const fileName = `downloaded_${Date.now()}.zip`;
    const filePath = path.join(__dirname, fileName);
    
    // Save to disk
    fs.writeFileSync(filePath, buffer);
    
    console.log(`✅ Saved ZIP to: ${filePath}`);
    console.log(`📊 File size: ${buffer.length} bytes`);
    
    // Try to read it with unzipper
    try {
      const directory = await unzipper.Open.file(filePath);
      const fileList = directory.files.map(file => ({
        path: file.path,
        size: file.uncompressedSize,
        compressed: file.compressedSize
      }));
      
      res.json({
        success: true,
        savedTo: fileName,
        fileSize: buffer.length,
        filesInZip: fileList
      });
      
    } catch (zipError) {
      res.json({
        success: false,
        savedTo: fileName,
        fileSize: buffer.length,
        zipError: zipError.message,
        firstBytes: buffer.slice(0, 16).toString('hex')
      });
    }

  } catch (err) {
    console.error("❌ Error:", err.message);
    res.status(500).json({ error: err.message });
  }
});

// List files using the saved approach
app.get("/list-zip-safe", async (req, res) => {
  try {
    const response = await axios({
      method: "GET",
      url: ZIP_URL,
      responseType: "arraybuffer",
      timeout: 30000
    });

    const buffer = Buffer.from(response.data);
    
    // Check if it's actually a ZIP file
    if (buffer.length < 4 || buffer[0] !== 0x50 || buffer[1] !== 0x4B) {
      return res.status(400).json({
        error: "Not a valid ZIP file",
        receivedBytes: buffer.length,
        firstBytes: buffer.slice(0, 16).toString('hex'),
        asText: buffer.slice(0, 200).toString('utf8')
      });
    }

    // Use unzipper with buffer
    const directory = await unzipper.Open.buffer(buffer);
    const fileList = directory.files
      .filter(file => file.type === 'File')
      .map(file => ({
        path: file.path,
        size: file.uncompressedSize
      }));

    res.json(fileList);

  } catch (err) {
    console.error("❌ Error:", err.message);
    res.status(500).json({ error: err.message });
  }
});

app.listen(3000, () => {
  console.log("✅ Server running at http://localhost:3000");
  console.log("🧪 Test endpoints:");
  console.log("   GET /download-zip - Download and save ZIP for inspection");
  console.log("   GET /list-zip-safe - List files using buffer approach");
});