const axios = require('axios');
const { pool } = require('../connection/connection');

/**
 * Update the 'authenticated' column for a given loginid
 * @param {number} loginid - The user's ID
 * @param {number} status - 0 or 1 (authenticated flag)
 * @returns {Promise<void>}
 */
async function updateAuthenticated(loginid, status) {
    try {
        const sql = 'UPDATE useraccountos SET authenticated = ?, redirectflag = ? WHERE id = ?';
        const [result] = await pool.query(sql, [status, status, loginid]);
        console.log(`Updated authenticated and redirectflag for loginid ${loginid} to ${status}`);
        return result;
    } catch (err) {
        console.error('Error updating authenticated:', err);
        throw err;
    }
}

/**
 * Call an API with the loginid dynamically
 * @param {string} apiUrl - The API endpoint
 * @param {number} loginid - The user's ID
 * @returns {Promise<void>}
 */
async function hitApiWithLoginId(apiUrl) {
    try {
        const response = await axios.get(apiUrl,{
            timeout:60000
        })
        console.log('API Response:', response.data);
        return response.data;
    } catch (error) {
        console.error('Error hitting API:', error.message);
        throw error;
    }
}

/**
 * Verify IMAP Email Credentials
 * @param {string} email
 * @param {string} password
 * @param {string} host
 * @returns {Promise<boolean>}
 */
async function verifyImapEmail(email, password, host) {
  try {
    const apiUrl = `http://103.148.165.134:5005/api/Imap/CheckIMAPMulti?id=${encodeURIComponent(email)}&pass=${encodeURIComponent(password)}&host=${encodeURIComponent(host)}`;
    console.log(apiUrl)
    const response = await axios.get(apiUrl, { timeout: 60000 });
    console.log("IMAP Verify Response:", response.data);

    // adjust this check based on API's actual success response
    return response.data === "ok" 
  } catch (error) {
    console.error("Error verifying IMAP:", error.message);
    return false;
  }
}



module.exports = {
    updateAuthenticated,
    hitApiWithLoginId,
    verifyImapEmail
};
