const express = require('express');
const { 
  getUserActivity, 
  getActivitySummary, 
  getProductivityReport 
} = require('../controllers/activityController');
const { validateUserId, validateLoginId } = require('../middleware/validateRequest');

const router = express.Router();

// GET /api/activity/:userid - Get user activity data
router.get('/:userid', validateUserId, getUserActivity);

// GET /api/activity/:userid/summary - Get activity summary with date range
router.get('/:userid/summary', validateUserId, getActivitySummary);

// GET /api/activity/reports/:loginid/productivity - Get productivity report for organization
router.get('/reports/:loginid/productivity', validateLoginId, getProductivityReport);

module.exports = router;