const express = require('express');
const { getAdminInfo, getDashboardStats } = require('../controllers/adminController');
const { validateLoginId } = require('../middleware/validateRequest');

const router = express.Router();

// GET /api/admin/:loginid - Get admin info and dashboard data
router.get('/:loginid', validateLoginId, getAdminInfo);

// GET /api/admin/:loginid/stats - Get dashboard statistics
router.get('/:loginid/stats', validateLoginId, getDashboardStats);

module.exports = router;