const jwt = require("jsonwebtoken")

class AuthMiddleware {
  verifyToken(req, res, next) {
    const token = req.header("Authorization")?.replace("Bearer ", "")

    if (!token) {
      return res.status(401).json({
        success: false,
        message: "Access denied. No token provided.",
      })
    }

    try {
      const decoded = jwt.verify(token, process.env.JWT_SECRET || "your-secret-key")
      req.user = decoded
      next()
    } catch (error) {
      res.status(401).json({
        success: false,
        message: "Invalid token.",
      })
    }
  }

  // Optional: Check if user has specific role
  checkRole(roles) {
    return (req, res, next) => {
      if (!req.user) {
        return res.status(401).json({
          success: false,
          message: "Access denied. User not authenticated.",
        })
      }

      // This would require adding role field to your user table
      // For now, we'll skip this implementation
      next()
    }
  }
}

module.exports = new AuthMiddleware()
