class LicenseController {
  async getLicenseInfo(req, res) {
    try {
      const empCloudDbPool = req.app.locals.empCloudDbPool
      const loginId = req.user.userId

      const [rows] = await empCloudDbPool.execute(
        `
        SELECT 
          tothdspace,
          curhdspace,
          licdays AS totalLicenseDays,
          hdfullpercentage,
          status,
          datecreated
        FROM license
        WHERE loginid = ?
        LIMIT 1
        `,
        [loginId]
      )

      if (!rows.length) {
        return res.status(404).json({
          success: false,
          message: "License not found",
        })
      }

      const lic = rows[0]

      /* ================= DATE CALCULATION ================= */
      const today = new Date()
      const createdDate = new Date(lic.datecreated)

      // Calculate difference in days
      const diffTime = today.getTime() - createdDate.getTime()
      const usedDays = Math.floor(diffTime / (1000 * 60 * 60 * 24))

      let remainingDays = lic.totalLicenseDays - usedDays
      if (remainingDays < 0) remainingDays = 0

      const licenseStatus = remainingDays > 0 ? "Active" : "Expired"

      /* ================= RESPONSE ================= */
      res.json({
        success: true,
        data: {
          totalHdSpace: lic.tothdspace,
          currentHdSpace: lic.curhdspace ?? 0,
          totalLicenseDays: lic.totalLicenseDays,
          usedDays: usedDays,
          licenseDaysPending: remainingDays,
          hdUsagePercentage: lic.hdfullpercentage,
          status: licenseStatus,
        },
      })
    } catch (error) {
      console.error("❌ License API error:", error)
      res.status(500).json({
        success: false,
        message: "Failed to fetch license info",
      })
    }
  }
}

module.exports = new LicenseController()
