const express = require("express")
const router = express.Router()
const userDetailsController = require("../controllers/userDetailsController")
const authMiddleware = require("../middleware/authMiddleware")

// ✅ Protect all routes
router.use(authMiddleware.verifyToken)

// ========== EXISTING ROUTES ==========

// Get all user details
router.get("/", userDetailsController.getUserDetails)

// ✅ Bulk update user details (assign depid etc.)
router.post("/bulk-update", userDetailsController.bulkUpdateUserDetails)

// Update single user details
router.put("/:id", userDetailsController.updateUserDetails)

// ========== 🆕 NEW ROUTES FOR REPORT GENERATION (MUST BE BEFORE /activity) ==========

// Get user activity data for report generation (with date range and days filter)
router.get("/activity-report", userDetailsController.getUserActivityForReport)

// Get activity summary for a user
router.get("/activity-summary", userDetailsController.getUserActivitySummary)

// ========== OLD ACTIVITY ROUTE (AFTER NEW ROUTES) ==========

// Get user activity data for specific date (existing endpoint)
router.get("/activity", userDetailsController.getUserActivityData)

// STEP 1: Check if data exists in database
router.post("/check-data", userDetailsController.checkDataExists)

// STEP 2: Download ZIP file from .NET API
router.get("/download-zip", userDetailsController.downloadZipFile)

// Legacy endpoint for backward compatibility
router.get("/images", userDetailsController.fetchUserImages)

// ========== 🗑️ UNINSTALL USER ROUTE ==========

// DELETE /api/user-details/uninstall/:userId
// Uninstall user, delete from userdetails and userlist, free license slot
router.delete("/uninstall/:userId", userDetailsController.uninstallUser)

module.exports = router