const jwt = require("jsonwebtoken")

class AuthMiddleware {

  /* ================= VERIFY JWT ================= */
  verifyToken(req, res, next) {
    const token = req.header("Authorization")?.replace("Bearer ", "")

    if (!token) {
      return res.status(401).json({
        success: false,
        message: "Access denied. No token provided.",
      })
    }

    try {
      const decoded = jwt.verify(
        token,
        process.env.JWT_SECRET || "your-secret-key"
      )
      req.user = decoded
      next()
    } catch (error) {
      return res.status(401).json({
        success: false,
        message: "Invalid token.",
      })
    }
  }

  /* ================= LICENSE READ-ONLY GUARD ================= */
  async blockIfReadonly(req, res, next) {
    try {
      const empCloudDbPool = req.app.locals.empCloudDbPool
      const loginId = req.user.userId

      const [[license]] = await empCloudDbPool.execute(
        "SELECT status FROM license WHERE loginid = ?",
        [loginId]
      )

      if (!license) {
        return res.status(403).json({
          success: false,
          message: "License not found.",
        })
      }

      if (license.status === 2) {
        return res.status(403).json({
          success: false,
          message: "License expired. System is in read-only mode.",
          code: "LICENSE_EXPIRED_READONLY",
        })
      }

      next()
    } catch (error) {
      console.error("❌ License readonly guard error:", error)
      res.status(500).json({
        success: false,
        message: "License validation failed.",
      })
    }
  }


  /* ================= OPTIONAL ROLE CHECK ================= */
  checkRole(roles) {
    return (req, res, next) => {
      if (!req.user) {
        return res.status(401).json({
          success: false,
          message: "Access denied. User not authenticated.",
        })
      }
      next()
    }
  }
}

module.exports = new AuthMiddleware()
