const express = require("express")
const router = express.Router()
const userActivityController = require("../controllers/userActivityController")
const authMiddleware = require("../middleware/authMiddleware")

// All routes require authentication
router.use(authMiddleware.verifyToken)

// User activity data routes
router.get("/:userId/service/:serviceId", userActivityController.getUserActivityData)
router.get("/:userId/service/:serviceId/summary", userActivityController.getUserActivitySummary)

module.exports = router
