const express = require("express")
const router = express.Router()
const authController = require("../controllers/authController.js")
const authMiddleware = require("../middleware/authMiddleware.js")

// Public routes
router.get("/verify-email/:token", authController.verifyEmail);
router.post("/resend-verification", authController.resendVerificationEmail);
router.post("/forgot-password", authController.forgotPassword);
router.post("/reset-password/:token", authController.resetPassword);

router.post("/signup", authController.signup)
router.post("/login", authController.login)

// Protected routes
router.get("/profile", authMiddleware.verifyToken, authController.getProfile)
router.put("/profile", authMiddleware.verifyToken, authController.updateProfile)
router.put("/exe-link", authMiddleware.verifyToken, authController.updateExeLink)
router.post("/logout", authMiddleware.verifyToken, authController.logout)


module.exports = router
