const express = require("express")
const router = express.Router()
const authMiddleware = require("../middleware/authMiddleware")
const {
  getDepartments,
  createDepartment,
  updateDepartment,
  deleteDepartment,
} = require("../controllers/departmentController")

// Get all departments
router.get("/", authMiddleware.verifyToken, getDepartments)

// Create new department
router.post("/", authMiddleware.verifyToken, createDepartment)

// Update department
router.put("/:id", authMiddleware.verifyToken, updateDepartment)

// Delete department
router.delete("/:id", authMiddleware.verifyToken, deleteDepartment)

module.exports = router
