const nodemailer = require("nodemailer")

// 🔍 DEBUG LOGS (VERY IMPORTANT)
console.log("📧 MAILER LOADED")
console.log("EMAIL_HOST =", process.env.EMAIL_HOST)
console.log("EMAIL_PORT =", process.env.EMAIL_PORT)
console.log("EMAIL_USER =", process.env.EMAIL_USER)

const transporter = nodemailer.createTransport({
  host: process.env.EMAIL_HOST,
  port: Number(process.env.EMAIL_PORT),
  secure: false, // true only for port 465
  auth: {
    user: process.env.EMAIL_USER,
    pass: process.env.EMAIL_PASS,
  },
})

// Optional: verify SMTP connection on startup
transporter.verify((error, success) => {
  if (error) {
    console.error("❌ SMTP VERIFY FAILED:", error.message)
  } else {
    console.log("✅ SMTP SERVER IS READY TO SEND MAILS")
  }
})

module.exports = transporter
