// const mysql = require("mysql2/promise")

// class DatabaseConfig {
//   constructor() {
//     this.empCloudDbPool = null
//     this.edb3Pool = null
//     this.adminDbPools = new Map()
//   }

//   createPools() {
//     try {
//       // Main EmpCloud database pool
//       this.empCloudDbPool = mysql.createPool({
//         host: process.env.DB_HOST || "localhost",
//         user: process.env.DB_USER || "root",
//         password: process.env.DB_PASSWORD || "",
//         database: process.env.DB_NAME || "empcloud",
//         waitForConnections: true,
//         connectionLimit: 10,
//         queueLimit: 0,
//         acquireTimeout: 60000,
//         timeout: 60000,
//         reconnect: true,
//       })

//       // EDB3 database pool
//       this.edb3Pool = mysql.createPool({
//         host: process.env.DB_HOST || "localhost",
//         user: process.env.DB_USER || "root",
//         password: process.env.DB_PASSWORD || "",
//         database: "edb3",
//         waitForConnections: true,
//         connectionLimit: 10,
//         queueLimit: 0,
//         acquireTimeout: 60000,
//         timeout: 60000,
//         reconnect: true,
//       })

//       console.log("✅ Database pools created successfully")

//       return {
//         empCloudDbPool: this.empCloudDbPool,
//         edb3Pool: this.edb3Pool,
//       }
//     } catch (error) {
//       console.error("❌ Error creating database pools:", error)
//       throw error
//     }
//   }

//   getAdminDbPool(adminId) {
//     const dbName = `edb${adminId}`

//     if (!this.adminDbPools.has(dbName)) {
//       try {
//         const pool = mysql.createPool({
//           host: process.env.DB_HOST || "localhost",
//           user: process.env.DB_USER || "root",
//           password: process.env.DB_PASSWORD || "",
//           database: dbName,
//           waitForConnections: true,
//           connectionLimit: 5,
//           queueLimit: 0,
//           acquireTimeout: 60000,
//           timeout: 60000,
//           reconnect: true,
//         })

//         this.adminDbPools.set(dbName, pool)
//         console.log(`✅ Created database pool for: ${dbName}`)
//       } catch (error) {
//         console.error(`❌ Error creating pool for ${dbName}:`, error)
//         throw error
//       }
//     }

//     return this.adminDbPools.get(dbName)
//   }

//   async testConnection() {
//     try {
//       if (this.empCloudDbPool) {
//         const [rows] = await this.empCloudDbPool.execute("SELECT 1 as test")
//         console.log("✅ EmpCloud database connection successful")
//       }

//       if (this.edb3Pool) {
//         const [rows] = await this.edb3Pool.execute("SELECT 1 as test")
//         console.log("✅ EDB3 database connection successful")
//       }

//       return true
//     } catch (error) {
//       console.error("❌ Database connection test failed:", error)
//       throw error
//     }
//   }

//   async testAdminDatabase(adminId) {
//     try {
//       const pool = this.getAdminDbPool(adminId)
//       const [rows] = await pool.execute("SELECT 1 as test")
//       console.log(`✅ Admin database edb${adminId} is accessible`)
//       return true
//     } catch (error) {
//       console.error(`❌ Admin database edb${adminId} test failed:`, error)
//       return false
//     }
//   }

//   async closeAllPools() {
//     try {
//       if (this.empCloudDbPool) {
//         await this.empCloudDbPool.end()
//         console.log("📊 EmpCloud database pool closed")
//       }

//       if (this.edb3Pool) {
//         await this.edb3Pool.end()
//         console.log("📊 EDB3 database pool closed")
//       }

//       for (const [dbName, pool] of this.adminDbPools) {
//         await pool.end()
//         console.log(`📊 ${dbName} database pool closed`)
//       }

//       this.adminDbPools.clear()
//     } catch (error) {
//       console.error("❌ Error closing database pools:", error)
//     }
//   }
// }

// module.exports = new DatabaseConfig()








const mysql = require("mysql2/promise")

class DatabaseConfig {
  constructor() {
    this.empCloudDbPool = null
    this.edb3Pool = null
    this.adminDbPools = new Map()
  }

  createPools() {
    try {
      this.empCloudDbPool = mysql.createPool({
        host: process.env.DB_HOST || "localhost",
        user: process.env.DB_USER || "root",
        password: process.env.DB_PASSWORD || "",
        database: process.env.DB_NAME || "empcloud",
        waitForConnections: true,
        connectionLimit: 10,
        queueLimit: 0,
        acquireTimeout: 60000,
        connectTimeout: 60000,   // ✅ correct option
        enableKeepAlive: true,   // ✅ keep TCP alive
        keepAliveInitialDelay: 0,
      })

      this.edb3Pool = mysql.createPool({
        host: process.env.DB_HOST || "localhost",
        user: process.env.DB_USER || "root",
        password: process.env.DB_PASSWORD || "",
        database: "edb3",
        waitForConnections: true,
        connectionLimit: 10,
        queueLimit: 0,
        acquireTimeout: 60000,
        connectTimeout: 60000,
        enableKeepAlive: true,
        keepAliveInitialDelay: 0,
      })

      console.log("✅ Database pools created successfully")
      return { empCloudDbPool: this.empCloudDbPool, edb3Pool: this.edb3Pool }
    } catch (error) {
      console.error("❌ Error creating database pools:", error)
      throw error
    }
  }

  getAdminDbPool(adminId) {
    const dbName = `edb${adminId}`

    if (!this.adminDbPools.has(dbName)) {
      try {
        const pool = mysql.createPool({
          host: process.env.DB_HOST || "localhost",
          user: process.env.DB_USER || "root",
          password: process.env.DB_PASSWORD || "",
          database: dbName,
          waitForConnections: true,
          connectionLimit: 5,
          queueLimit: 0,
          acquireTimeout: 60000,
          connectTimeout: 60000,
          enableKeepAlive: true,
          keepAliveInitialDelay: 0,
        })

        this.adminDbPools.set(dbName, pool)
        console.log(`✅ Created database pool for: ${dbName}`)
      } catch (error) {
        console.error(`❌ Error creating pool for ${dbName}:`, error)
        throw error
      }
    }

    return this.adminDbPools.get(dbName)
  }

  async testConnection() {
    try {
      if (this.empCloudDbPool) {
        const [rows] = await this.empCloudDbPool.execute("SELECT 1 as test")
        console.log("✅ EmpCloud database connection successful")
      }

      if (this.edb3Pool) {
        const [rows] = await this.edb3Pool.execute("SELECT 1 as test")
        console.log("✅ EDB3 database connection successful")
      }

      return true
    } catch (error) {
      console.error("❌ Database connection test failed:", error)
      throw error
    }
  }

  async testAdminDatabase(adminId) {
    try {
      const pool = this.getAdminDbPool(adminId)
      const [rows] = await pool.execute("SELECT 1 as test")
      console.log(`✅ Admin database edb${adminId} is accessible`)
      return true
    } catch (error) {
      console.error(`❌ Admin database edb${adminId} test failed:`, error)
      return false
    }
  }

  async closeAllPools() {
    try {
      if (this.empCloudDbPool) {
        await this.empCloudDbPool.end()
        console.log("📊 EmpCloud database pool closed")
      }

      if (this.edb3Pool) {
        await this.edb3Pool.end()
        console.log("📊 EDB3 database pool closed")
      }

      for (const [dbName, pool] of this.adminDbPools) {
        await pool.end()
        console.log(`📊 ${dbName} database pool closed`)
      }

      this.adminDbPools.clear()
    } catch (error) {
      console.error("❌ Error closing database pools:", error)
    }
  }
}

module.exports = new DatabaseConfig()
