const express = require("express")
const router = express.Router()
const authController = require("../controllers/authController")
const authMiddleware = require("../middleware/authMiddleware.js")

// Public routes
router.post("/signup", authController.signup)
router.post("/login", authController.login)

// Protected routes
router.get("/profile", authMiddleware.verifyToken, authController.getProfile)
router.put("/profile", authMiddleware.verifyToken, authController.updateProfile)
router.put("/exe-link", authMiddleware.verifyToken, authController.updateExeLink)
router.post("/logout", authMiddleware.verifyToken, authController.logout)

module.exports = router
