const express = require("express")
const router = express.Router()
const ApiHelper = require("../utils/apiHelper")

// Test .NET API connectivity
router.get("/dotnet-api/test", async (req, res) => {
  try {
    const testResult = await ApiHelper.testDotNetApiConnection()

    res.json({
      success: true,
      message: "API connectivity test completed",
      result: testResult,
    })
  } catch (error) {
    res.status(500).json({
      success: false,
      message: "Test failed",
      error: error.message,
    })
  }
})

// Test .NET API call with sample orgId
router.get("/dotnet-api/init/:orgId", async (req, res) => {
  try {
    const { orgId } = req.params
    const result = await ApiHelper.callDotNetApi(orgId)

    res.json({
      success: result.success,
      message: result.success ? ".NET API call successful" : ".NET API call failed",
      result: result,
    })
  } catch (error) {
    res.status(500).json({
      success: false,
      message: "Test failed",
      error: error.message,
    })
  }
})

module.exports = router
