const express=require("express")
const app=express()
const {pool}=require('./connection/connection.js')
const cors= require('cors')
const cookieParser = require('cookie-parser')
const authRoutes =require('./router/authRouter.js')
const backupAccountRoutes =require('./router/backupAccountRouter.js')
const statRoutes =require('./router/statisicRouter.js')
const ongoingRoutes =require('./router/OngoingRouter.js')
const restoreRoutes = require('./router/restoreBackupRouter.js')
const updationRoutes = require('./router/updationRouter.js')
const notiRoutes=require('./router/notificationRouter.js')
const axios=require('axios')
app.use(cookieParser())
// connection()

var whitelist = ['http://localhost:5173',"http://103.139.58.182","https://mailexport.com"]
app.use(cors({
  origin: function (origin, callback) {
    if (whitelist.indexOf(origin) !== -1) {
      callback(null, true)
    } else {
      callback(new Error('Not allowed by CORS'))
    }
  }, 
  credentials: true,
  methods: ['GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'] // Add other methods as needed
}));
app.use(express.json())
app.use(express.urlencoded({extended:true}))


// app.get('/download', async (req, res) => {
//   const fileUrl = 'http://103.57.64.107:5005/api/Download/11/1';

//   try {
//     // Get content-length first
//     const headResponse = await axios.head(fileUrl);
//     const contentLength = headResponse.headers['content-length'];

// if (contentLength) {
//   res.setHeader('Content-Length', contentLength);
// }
//     // Stream the actual file
//     const response = await axios.get(fileUrl, { responseType: 'stream' });

//     // res.setHeader('Content-Length', contentLength);
//     res.setHeader('Content-Disposition', 'attachment; filename="CBMain.pdb"');
//     res.setHeader('Content-Type', response.headers['content-type']);

//     response.data.pipe(res);
//   } catch (error) {
//     console.error('Download error:', error);
//     res.status(500).send('Error downloading file');
//   }
// });

  app.use('/', authRoutes);
  app.use('/', backupAccountRoutes);
  app.use('/', statRoutes);
  app.use('/', ongoingRoutes);
  app.use('/', restoreRoutes);
  app.use('/', updationRoutes);
  app.use('/', notiRoutes);
  
app.listen(5000,()=>{
  console.log("node is running on port : 5000")
})