const express= require('express')
const app=express()
const {pool} = require('../connection/connection')
const jwt= require('jsonwebtoken')
const {log} =require('../logger/log')
const axios=require("axios")
const verificationMailSend=require('../utils/sendVerificationMail')
const uniquetokenGenerate=require('../utils/verificationTokenGeneration')
const bcrypt = require('bcrypt');
const saltRounds = 10;
const secretKey = 'asdgj-sm34m-q4gf3-qj124-ak262';


// const userSignup= async (req, res) => {
//     let connection;
//     try {
//       connection =  pool;
//       const { email, password,fname,lname,uname } = req.body;
      
      
//       const verifyQuery = 'SELECT email FROM useraccountos WHERE email = (?)';
//       const [exeVerify] = await connection.query(verifyQuery, [email]);
      
      
//       if (exeVerify.length === 0) {
//         const token=uniquetokenGenerate(email)
//       const sendMail=await verificationMailSend(email,`${fname+" "+ lname||"" }`,token.jwtToken)
//       if(sendMail.success){
//     // log(exeVerify.length ===0, "verifyQuery");
  
//         const query = 'INSERT INTO useraccountos(email, password,firstname,lastname,username,redirectFlag,token) VALUES(?, ?, ?, ?, ?,0,?)';
//         const [result] = await connection.query(query, [email, password,fname,lname,uname,token.jwtToken]);
        
//         const newID=result?.insertId
// // console.log(newID,"primary id")
//         const query2=`UPDATE useraccountos SET dbname=? WHERE id= ?`
//         const [update]= await connection.query( query2,[`db${newID}`,newID]);


//         const query3=`INSERT INTO license(loginid,productid,nouser,hdspace,status,col1) VALUES(?,?,?,?,?,?)`;
//         const [insertInLicense]=await connection.execute(query3,[newID,1,3,0,1,0])
                   
//         res.status(200).json({ response: "Successfully user created", AccountExists: false });


//       } else {
//         res.json({ AccountExists: true });
//       }

//     }
//     else{
//       res.json({emailsent:false})
//     }
//     } catch (error) {
//      console.log(error,"ERROR")
//       res.status(500).json({ error: 'An error occurred' });
//     }
//   } 

const userSignup = async (req, res) => {
  try {
    const { email, password, fname, lname, uname } = req.body;
    
    const verifyQuery = 'SELECT email FROM useraccountos WHERE email = ?';
    const [exeVerify] = await pool.query(verifyQuery, [email]);
    
    if (exeVerify.length === 0) {
      const hashedPassword = await bcrypt.hash(password, saltRounds);
      const token = uniquetokenGenerate(email);
      const sendMail = await verificationMailSend(email, `${fname + " " + lname || ""}`, token.jwtToken);
      
      if (sendMail.success) {
        const query = 'INSERT INTO useraccountos(email, password, firstname, lastname, username, redirectFlag, token) VALUES(?, ?, ?, ?, ?, 0, ?)';
        const [result] = await pool.query(query, [email, hashedPassword, fname, lname, uname, token.jwtToken]);
        
        const newID = result?.insertId;
        const query2 = 'UPDATE useraccountos SET dbname = ? WHERE id = ?';
        await pool.query(query2, [`db${newID}`, newID]);
        
        const query3 = 'INSERT INTO license(loginid, productid, nouser, hdspace, status, col1) VALUES(?,?,?,?,?,?)';
        await pool.execute(query3, [newID, 99, 3, 0, 1, 0]);
        
        return res.status(200).json({ 
          response: "Successfully user created", 
          AccountExists: false 
        });
      } else {
        return res.status(500).json({ 
          message: "Email verification failed", 
          emailsent: false,
          AccountExists: false 
        });
      }
    } else {
      return res.status(200).json({ 
        message: "Account already exists", 
        AccountExists: true 
      });
    }
  } catch (error) {
    log(error, "ERROR");
    res.status(500).json({ 
      error: 'An error occurred during signup',
      AccountExists: false 
    });
  }
};

// const login=  async (req, res) => {
//     let connection;
//     try {
//       connection = pool;
//       const { email, password } = req.body;
//       // console.log(email)
//       const verifyQuery = 'SELECT id,email,password,firstname,verified FROM useraccountos WHERE email = ? AND password = ?';
//       const getEmailType=`SELECT 
//     license.id,
//     license.loginid,
//     license.productid,
//     product.type
// FROM 
//     license
// JOIN 
//     product ON license.productid = product.id 
// WHERE 
//     license.loginid = ?`

//       const [exeVerify] = await connection.query(verifyQuery, [email,password]);
//     //   console.log(exeVerify.length ===0, "verifyQuery");
//   // log(exeVerify)
  
//       if (exeVerify.length !== 0) {


//         if(exeVerify[0].verified!=0 && exeVerify[0].email){
//         const user = { email,id:exeVerify[0].id }; 
//         const [getemailAccountType]=await connection.query(getEmailType,[exeVerify[0].id])
//         const storeType=getemailAccountType[0].type
//         const accessToken = jwt.sign(user, secretKey, { expiresIn: '1h' });

//         res.cookie('uid',exeVerify[0].id,{
//           maxAge:61721902,
//           path:'/',
//           httpOnly:false,
//         })
//  res.cookie('name',exeVerify[0].firstname,{
//           maxAge:61721902,
//           path:'/',
//           httpOnly:false,
//         })
//         res.status(200).json({ accessToken ,AccountExists: "Login success",accType:btoa(storeType),email:true });
// }
// else{

//   res.status(403).json({email:false})
// }

//       } 
      
//       else {
//       res.json({ AccountExists: "Email not registered" });
//       }
//     } catch (error) {
//       log(error,"ERROR")
//       res.status(500).json({ error: 'An error occurred' });
//     } 
//   }


const login = async (req, res) => {
  let connection;
  try {
    connection = pool;
    const { email, password } = req.body;

    // Validate input
    if (!email || !password) {
      return res.status(400).json({ 
        success: false, 
        error: "Email and password are required", 
        code: "MISSING_FIELDS" 
      });
    }

    const verifyQuery = 'SELECT id, email, password, firstname, verified FROM useraccountos WHERE email = ?';
    const [exeVerify] = await connection.query(verifyQuery, [email]);

    if (exeVerify.length === 0) {
      return res.status(404).json({ 
        success: false, 
        error: "Email not registered", 
        code: "EMAIL_NOT_FOUND" 
      });
    }

    const user = exeVerify[0];

    const passwordMatch = await bcrypt.compare(password, user.password);
    if (!passwordMatch) {
      return res.status(401).json({ 
        success: false, 
        error: "Incorrect password", 
        code: "WRONG_PASSWORD" 
      });
    }

    if (user.verified == 0) {
      return res.status(403).json({ 
        success: false, 
        error: "Email not verified", 
        code: "EMAIL_NOT_VERIFIED" 
      });
    }

    // Get user account type
    // const getEmailType = `SELECT 
    //   license.id,
    //   license.loginid,
    //   license.productid,
    //   product.type
    //   FROM license
    //   JOIN product ON license.productid = product.id 
    //   WHERE license.loginid = ?`;

const getEmailType=`SELECT 
    license.id,
    license.loginid,
    license.productid,
    CASE 
        WHEN LOWER(product.productname) LIKE '%multiple%' THEN 1
        WHEN LOWER(product.productname) LIKE '%single%' THEN 0
        ELSE NULL
    END AS type
FROM license
JOIN product ON license.productid = product.id 
WHERE license.loginid = ?;
`

    
    const [getEmailAccountType] = await connection.query(getEmailType, [user.id]);
    console.log(getEmailAccountType)
    // Handle case where user has no license/product type
    if (!getEmailAccountType || getEmailAccountType.length === 0) {
      return res.status(400).json({ 
        success: false, 
        error: "No account type found for user", 
        code: "NO_ACCOUNT_TYPE" 
      });
    }

    const storeType = getEmailAccountType[0].type;
    console.log(storeType,"asdhavhsdhga")
    const accessToken = jwt.sign({ email, uid: user.id ,type:storeType}, secretKey, { expiresIn: '2h' });

    // Set cookies
    res.cookie('uid', user.id, { maxAge: 61721902, path: '/', httpOnly: false });
    res.cookie('name', user.firstname, { maxAge: 61721902, path: '/', httpOnly: false });

    // Send consistent success response
res.status(200).json({
  success: true,
  accessToken,
  AccountExists: "Login success",
  accType: storeType !== null ? btoa(storeType.toString()) : btoa("unknown"),
  email: true,
  user: {
    id: user.id,
    email: user.email,
    firstname: user.firstname
  }
});

  } catch (error) {
   log(error,"Login error");
    res.status(500).json({ 
      success: false,
      error: 'An error occurred during login',
      code: "INTERNAL_ERROR"
    });
  }
};




  const setAuthFlag=async(req,res)=>{
    try{
  const connection = await pool
  console.log(req.user)
  const {uid}=req.user
  const setFlag=await connection.query(`UPDATE useraccountos SET redirectflag=1 WHERE id =?`,[uid])
  // console.log('flag set successfully')
  res.status(200).send({flagSet:true})
  
    }
    catch(error){
     log(error,"ERROR")

      res.status(500).send('Internal server error')
    } 
  }


const checkAuthCompletion = async (req, res) => {
  const db = await pool;
  try {
    const { uid } = req.user;

    if (!uid) {
      return res.status(400).json({ error: "Missing UID in cookies" });
    }

    const query = "SELECT authenticated FROM useraccountos WHERE id=? ";
    const [rows] = await db.query(query, [uid]);

    if (rows.length && rows[0].authenticated) {
      res.status(200).send(true);
    } else {
      res.status(401).send(false);
    }

  } catch (error) {
    log(error, "ERROR");
    res.status(500).json({ error: "Internal Server Error", details: error.message });
  }
};


const getMxRecords = async (req, res) => {
  try {
    const email = req.query.email;
    const response = await axios.get(`https://imapsettings.com/json-mx.php?email=${email}`);
    // log(response)
    res.status(200).json(response.data);
  } catch (error) {
    log(error.message,'Error fetching MX records');
    res.status(500).json({ error: 'Unable to fetch MX records' });
  }
};



const verifyEmail = async (req, res) => {
  const { token,email } = req.body; // or req.params.token if using route params

  if (!token) {
    return res.status(400).json({ success: false, message: 'Token is required' });
  }

  try {
    const connection = pool;

    // 1. Find user by token
    const [rows] = await connection.query(
      'SELECT id, verified FROM useraccountos WHERE email = ?',
      [email]
    );

    if (rows.length === 0) {
      return res.status(400).json({ success: false, message: 'Invalid or expired token' });
    }

    const user = rows[0];

    // 2. Check if already verified
    if (user.verified === 1) {
      return res.status(200).json({ success: true, alreadyVerified: true });
    }

    // 3. Update verified to 1 and clear token
    await connection.query(
      'UPDATE useraccountos SET verified = 1, token = NULL WHERE id = ?',
      [user.id]
    );

    return res.status(200).json({ success: true, message: 'Email verified successfully' });
  } catch (error) {
    log(error,'Verification error:');
    return res.status(500).json({ success: false, message: 'Server error' });
  }
};



const changePassword = async (req, res) => {
  try {
    const { email, oldPassword, newPassword } = req.body;

    if (!email || !oldPassword || !newPassword) {
      return res.status(400).json({ message: "All fields are required" });
    }

    // Check if user exists
    const [rows] = await pool.query('SELECT password FROM useraccountos WHERE email = ?', [email]);

    if (rows.length === 0) {
      return res.status(404).json({ message: "User not found" });
    }

    const storedHash = rows[0].password;

    // Verify old password
    const isMatch = await bcrypt.compare(oldPassword, storedHash);
    if (!isMatch) {
      return res.status(401).json({ message: "Old password is incorrect" });
    }

    // Hash new password
    const hashedNewPassword = await bcrypt.hash(newPassword, saltRounds);

    // Update password
    await pool.query('UPDATE useraccountos SET password = ? WHERE email = ?', [hashedNewPassword, email]);

    return res.status(200).json({ message: "Password changed successfully" });
  } catch (error) {
    log(error, "ERROR");
    return res.status(500).json({ message: "Internal server error" });
  }
};






async function updateLicenseAndToken(req, res) {
  try {
    const { accountType, provider } = req.body.data;
    const id = req.user.uid;

    // ✅ Check if user is authenticated
    const [users] = await pool.query(
      `SELECT authenticated FROM useraccountos WHERE id = ? LIMIT 1`,
      [id]
    );

    if (users.length === 0) {
      return res.status(404).json({ message: "User not found" });
    }

    if (users[0].authenticated !== 1) {
      return res.status(403).json({ message: "User not authenticated" });
    }

    // ✅ Normalize account type
    let normalizedType = "";
    if (
      accountType.toLowerCase() === "business" ||
      accountType.toLowerCase() === "multiple"
    ) {
      normalizedType = "multiple";
    }
    if (
      accountType.toLowerCase() === "single" ||
      accountType.toLowerCase() === "personal"
    ) {
      normalizedType = "single";
    }

    // ✅ Find product row
    const [products] = await pool.query(
      `SELECT id, productname 
       FROM product 
       WHERE LOWER(productname) LIKE ? 
         AND LOWER(productname) LIKE ? 
       LIMIT 1`,
      [`%${provider.toLowerCase()}%`, `%${normalizedType}%`]
    );

    if (products.length === 0) {
      return res.status(404).json({ message: "Matching product not found" });
    }

    const productId = products[0].id;

    // ✅ Update license table
    await pool.query(
      `UPDATE license 
       SET productid = ? 
       WHERE loginid = ?`,
      [productId, id]
    );

    // ✅ Refresh JWT token with updated type
    const userData = { ...req.user, type: normalizedType === "multiple" ? 1 : 0 };
    const newToken = jwt.sign(userData, secretKey);

    res.json({
      message: "License updated and token refreshed",
      token: newToken,
    });

  } catch (err) {
    console.error("Error:", err);
    res.status(500).json({ message: "Internal server error" });
  }
}



 module.exports={userSignup,login,setAuthFlag,checkAuthCompletion,getMxRecords,verifyEmail,updateLicenseAndToken} 