const express = require('express')
const app = express()
const {pool} = require('../connection/connection')
const { log } = require('../logger/log')
const fs = require("fs");
const csvParser = require("csv-parser");
const { updateAuthenticated, hitApiWithLoginId ,verifyImapEmail} = require("../utils/ImapUserHandle");
const { error } = require('console');



//to fetch userlist
const fetchUserList = async (req, res) => {
    const connection = await pool
    try {

        const { uid } = req.user

        const [query] = await connection.query(`SELECT * FROM db${uid}.userlist`)

        res.status(200).json({ userList: query })


    }
    catch (error) {
        log(error, "ERROR")
        res.status(500).json({ message: "Internal Server Error" })


    }
 
}




//to save preference
const backupPrefrences = async (req, res) => {
    const connection = await pool
    try {

        const { uid } = req.user
        const { contacts, mail, calender } = req.body
        const query = `INSERT INTO db${uid}.usermailsettings(loginid,email,con,cal,task,note) VALUES (?,?,?,?,?,?)`
        const insertSettings = await connection.query(query, [uid, mail, contacts, calender, 0, 0])

        res.status(200).json({ success: "Prefrences Saved" })


    }
    catch (error) {
        log(error, "ERROR")
        res.status(500).json({ message: "Internal Server Error" })


    }
   
}




//to fetch recent 
const recentBackup = async (req, res) => {
    const connection = await pool
    try {

        const { uid } = req.user

        const query = `SELECT * FROM db${uid}.userbackupmain WHERE loginid=? ORDER BY id DESC LIMIT 1;`
        const [getRecentBackup] = await connection.query(query, [uid])

        res.status(200).json({ data: getRecentBackup })


    }
    catch (error) {
        log(error, "ERROR")
        res.status(500).json({ message: "Internal Server Error" })


    }

}


const getMailCountByLoginId = async (req, res) => {
    const db = await pool;

    try {
        const { uid } = req.user;

        const [rows] = await db.query(`
      SELECT 
        loginid, 
        SUM(mailcount) AS total_mailcount,
        MAX(etime) AS latest_etime
      FROM db${uid}.userbackupmain
      GROUP BY loginid
    `);

        res.json(rows);
    } catch (error) {
        log(error, "ERROR");
        res.status(500).json({ error: 'Internal Server Error' });
    }
   
};




const getLicenseandProductDetails = async (req, res) => {
    const db = await pool
    try {
        const { uid } = req.user
        const query = `SELECT 
    license.id,
    license.loginid,
    license.productid,
    license.nouser,
    license.hdspace,
    license.status,
    license.col1,
    license.col2,
    license.datecreated,
    product.productname,   
    CASE 
        WHEN LOWER(product.productname) LIKE '%multiple%' THEN 1
        ELSE 0
    END AS type,
  useraccountos.actype
FROM 
    license
JOIN 
    product ON license.productid = product.id 
JOIN 
    useraccountos ON license.loginid = useraccountos.id  
WHERE 
    license.loginid = ?;
`
        const [execute] = await db.query(query, [uid])
        log(execute,"imapmultierror")

        res.status(200).json({ data: execute })

    }
    catch (error) {
        log(error, "ERROR")
    }
   
}


const onBakcupJobSubmit = async (req, res) => {
    const db = await pool;
    const uid = req.user.uid;

    if (!uid) {
        return res.status(400).json({ error: "User not authenticated" });
    }
log(req.body.selectedUsersData,"job submit")

    try {
        const { accountType, selectedUsersData, selectedFolders,preferences } = req.body;
//   console.log(selectedFolders)
        if (!accountType || !selectedFolders) {
            return res.status(400).json({ error: "Missing required fields" });
        }

        // if (accountType === "multiple" && Array.isArray(selectedUsersData)) {
        //     const query1 = `UPDATE db${uid}.userlist SET selected=1 WHERE useremail=?`;

        //     for (const element of selectedUsersData) {
        //         if (element?.email) {
        //             await db.query(query1, [element.email]);
        //         }
        //     }
        // }

if (accountType === "multiple" && Array.isArray(selectedUsersData)) {
    for (const element of selectedUsersData) {
        if (element?.email) {
            const apps = element.apps?.toLowerCase() ?? "";
            const hasOneDrive = apps.includes("onedrive");
            const hasEmail = apps.includes("email");

            let updateQuery = `UPDATE db${uid}.userlist SET selected=1`;
            const params = [];

            if (hasOneDrive) updateQuery += `, odselected=1`;
            if (hasEmail) updateQuery += `, emailselected=1`;

            updateQuery += ` WHERE useremail=?`;
            params.push(element.email);

            await db.query(updateQuery, params);
        }
    }
}

        const query2 = `
            INSERT INTO db${uid}.usermailsettings
            (loginid, email, con, cal, task, note,frequency)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        `;

        await db.query(query2, [
            uid,
            selectedFolders?.mails ?? 0,
            selectedFolders?.contacts ?? 0,
            selectedFolders?.calendar ?? 0,
            selectedFolders?.tasks ?? 0,
            selectedFolders?.notes ?? 0,
            preferences?.backupFrequency ?? 1
        ]);
  
        const query3 ='UPDATE useraccountos SET jobcreated=? WHERE id=?'
        await db.query(query3,[1,uid])
        return res.status(200).json({ success: "Preferences Saved" });

    } catch (error) {
        log(error,"Error in onBakcupJobSubmit");
        return res.status(500).json({ error: "Internal Server Error" });
    }
    finally{
        db.end()
    }
};



///to check if job has been created or not
const CheckJobCreated = async(req,res)=>{
        const db = await pool;
    const uid = req.user.uid;

    if (!uid) {
        return res.status(400).json({ error: "User not authenticated" });
    }

    try{
        
        const query="SELECT jobcreated FROM useraccountos WHERE id=?"
        const[result]=await db.query(query,[uid])
        res.status(200).json(result)
    }
    catch(error){
        log(error,"ERROR")
        res.status(501).json({message:"Internal Server Error"})
    }
   
}



const getCollectiveBackup=async(req,res)=>{
    const db=await pool
    
    try{
        const { uid } = req.user
const query = `
 SELECT 
  DATE(db${uid}.userbackupmain.stime) AS backup_date,
  COUNT(*) AS total_entries,
  SUM(db${uid}.userbackupmain.mailcount) AS total_mailcount,
  SUM(db${uid}.userbackupmain.concount) AS total_concount,
  SUM(db${uid}.userbackupmain.calcount) AS total_calcount,
  SUM(db${uid}.userbackupmain.taskcount) AS total_taskcount,
  SUM(db${uid}.userbackupmain.notecount) AS total_notecount,

  SUM(db${uid}.userbackupmain.mailcount + db${uid}.userbackupmain.concount + db${uid}.userbackupmain.calcount + db${uid}.userbackupmain.notecount +db${uid}.userbackupmain.taskcount  ) AS total_contcount,

  SUM(db${uid}.userbackupmain.totmailcount + db${uid}.userbackupmain.totconcount + db${uid}.userbackupmain.totcalcount+ db${uid}.userbackupmain.totnotecount+db${uid}.userbackupmain.tottaskcount  ) AS total_totalcount,
  COUNT(*) AS completed_backups
FROM db${uid}.userbackupmain
WHERE db${uid}.userbackupmain.eflag = 1 
  AND (db${uid}.userbackupmain.mailcount + db${uid}.userbackupmain.concount + db${uid}.userbackupmain.calcount + db${uid}.userbackupmain.notecount + db${uid}.userbackupmain.taskcount) != 0
GROUP BY DATE(db${uid}.userbackupmain.stime)
ORDER BY backup_date DESC;
`;


 const [execute]=await db.query(query)
 res.status(200).json(execute)
    }
    catch(error){
    log(error,"Collective Backup Error")
    }
   
}


const userWiseBackupData=async(req,res)=>{
       const db=await pool
    
    try{
        const { uid } = req.user
const query = `
  SELECT 
    DATE(f.stime) AS backup_date,
    f.userid,
    u.useremail,
    u.name,
    f.id,
    COUNT(*) AS total_entries,
    SUM(f.mailcount) AS total_mailcount,
    SUM(f.concount) AS total_concount,
    SUM(f.calcount) AS total_calcount,
    SUM(f.notecount) AS total_notecount,
    SUM(f.taskcount) AS total_taskcount,
    COUNT(*) AS completed_backups
  FROM db${uid}.userbackupmain f
  JOIN db${uid}.userlist u ON f.userid = u.id
  WHERE f.eflag = 1 AND (f.mailcount + f.concount + f.calcount + f.notecount + f.taskcount) != 0
  GROUP BY DATE(f.stime), f.userid, u.useremail, u.name
  ORDER BY backup_date DESC, f.userid;
`;

 const [execute]=await db.query(query)
 res.status(200).json(execute)
    }
    catch(error){
    log(error,"Collective Backup Error")
    }
 
}



const FolderwiseMailBackupData=async(req,res)=>{
       const db=await pool
    
    try{
        const { uid } = req.user
const query = `
  SELECT 
    ubmf.id AS mailfolder_id,
    ubmf.userid,
    u.useremail,
    u.name,
    ubmf.backupmainid,
    ubmf.stime,
    ubmf.etime,
    ubmf.mailcount,
    ubmf.foldername,
    ubmf.totalcount
FROM db${uid}.userbackupmailfolders ubmf
JOIN db${uid}.userlist u
  ON ubmf.userid = u.id;
`;

 const [execute]=await db.query(query)
 res.status(200).json(execute)
    }
    catch(error){
    log(error,"Collective Backup Error")
    }
 
}

const FolderwiseContactBackupData=async(req,res)=>{
       const db=await pool
    
    try{
        const { uid } = req.user
const query = `
  SELECT 
    ubmf.id AS mailfolder_id,
    ubmf.userid,
    u.useremail,
    u.name,
    ubmf.backupmainid,
    ubmf.stime,
    ubmf.etime,
    ubmf.contactcount,
    ubmf.contactfoldername,
    ubmf.totalcount
FROM db${uid}.userbackupcontacts ubmf
JOIN db${uid}.userlist u
  ON ubmf.userid = u.id;
`;

 const [execute]=await db.query(query)
 res.status(200).json(execute)
    }
    catch(error){
    log(error,"Collective Backup Error")
    }
 
}

const FolderwiseNotesBackupData=async(req,res)=>{
       const db=await pool
    
    try{
        const { uid } = req.user
const query = `
  SELECT 
    ubmf.id AS mailfolder_id,
    ubmf.userid,
    u.useremail,
    u.name,
    ubmf.backupmainid,
    ubmf.stime,
    ubmf.etime,
    ubmf.notecount,
    ubmf.notefoldername,
    ubmf.totalcount
FROM db${uid}.userbackupnotes ubmf
JOIN db${uid}.userlist u
  ON ubmf.userid = u.id;
`;

 const [execute]=await db.query(query)
 res.status(200).json(execute)
    }
    catch(error){
    log(error,"Collective Backup Error")
    }
 
}


const FolderwiseCalendarBackupData=async(req,res)=>{
       const db=await pool
    
    try{
        const { uid } = req.user
const query = `
  SELECT 
    ubmf.id AS mailfolder_id,
    ubmf.userid,
    u.useremail,
    u.name,
    ubmf.backupmainid,
    ubmf.stime,
    ubmf.etime,
    ubmf.calendarcount,
    ubmf.calendarfoldername,
    ubmf.totalcount
FROM db${uid}.userbackupcalendars ubmf
JOIN db${uid}.userlist u
  ON ubmf.userid = u.id;
`;

 const [execute]=await db.query(query)
 res.status(200).json(execute)
    }
    catch(error){
    log(error,"Collective Backup Error")
    }
 
}



const FolderwiseTaskBackupData=async(req,res)=>{
       const db=await pool
    
    try{
        const { uid } = req.user
const query = `
  SELECT 
    ubmf.id AS mailfolder_id,
    ubmf.userid,
    u.useremail,
    u.name,
    ubmf.backupmainid,
    ubmf.stime,
    ubmf.etime,
    ubmf.taskcount,
    ubmf.taskfoldername,
    ubmf.totalcount
FROM db${uid}.userbackuptasks ubmf
JOIN db${uid}.userlist u
  ON ubmf.userid = u.id;
`;

 const [execute]=await db.query(query)
 res.status(200).json(execute)
    }
    catch(error){
    log(error,"Collective Backup Error")
    }
 
}


const FolderwiseDriveBackupData=async(req,res)=>{
       const db=await pool
    
    try{
        const { uid } = req.user
const query = `
  SELECT 
    ubmf.id AS mailfolder_id,
    ubmf.userid,
    u.useremail,
    u.name,
    ubmf.backupmainid,
    ubmf.stime,
    ubmf.etime,
    ubmf.odcount,
    ubmf.odfoldername,
    ubmf.totalcount
FROM db${uid}.userbackupod ubmf
JOIN db${uid}.userlist u
  ON ubmf.userid = u.id;
`;

 const [execute]=await db.query(query)
 res.status(200).json(execute)
    }
    catch(error){
    log(error,"Collective Backup Error")
    }
 
}




const getfiveOngoingBackup=async(req,res)=>{
       const db=await pool
  try{
        const { uid } = req.user
            const schema = `db${uid}`;
const query = `
  SELECT
    f.userid,
    u.useremail,
    u.name,
    SUM(f.mailcount + f.calcount + f.concount + f.notecount + f.taskcount) AS total_count_sum,
    SUM(f.totmailcount + f.totconcount + f.totcalcount + f.tottaskcount + f.totnotecount) AS total_totcount_sum
  FROM ${schema}.userbackupmain f
  JOIN ${schema}.userlist u ON f.userid = u.id
  WHERE f.eflag = 0 AND f.sflag = 1
  GROUP BY f.userid, u.useremail, u.name
  ORDER BY total_count_sum DESC
  LIMIT 5;
`;

// const query=`
// SELECT
//   SUM(f.mailcount + f.calcount + f.concount + f.notecount + f.taskcount) AS total_count_sum,
//   SUM(f.totmailcount + f.totconcount + f.totcalcount + f.tottaskcount + f.totnotecount) AS total_totcount_sum,
//    f.userid,
//   u.useremail,
//   u.name,
// FROM (
//   SELECT f.*
//   FROM ${schema}.userbackupmain f
//   JOIN ${schema}.userlist u ON f.userid = u.id
//   WHERE f.eflag = 0 AND f.sflag = 1
//   ORDER BY f.id DESC
//   LIMIT 5
// ) f;`

 const [execute]=await db.query(query)
 res.status(200).json(execute)
    }
    catch(error){
    log(error,"Collective Backup Error")
    }
     
}






// Helper: generate unique userid using milliseconds
function generateUserId() {
  return Date.now().toString() + Math.floor(Math.random() * 1000);
}


// const imapMultipleAccount = async (req, res) => {
//   if (!req.file) {
//     return res.status(400).json({ error: "CSV file is required" });
//   }

//   const results = [];

//   fs.createReadStream(req.file.path)
//     .pipe(csvParser())
//     .on("data", (row) => {
//       const email = row.email?.trim();
//       const password = row.password?.trim();
//       const name = row.display_name?.trim() || null;
//       const host = row.host?.trim() || null;

//       if (email && password) {
//         results.push({
//           userid: generateUserId(),
//           useremail: email,
//           password,
//           name,
//           host,
//           vtype: 2, // IMAP
//         });
//       }
//     })
//     .on("end", async () => {
//       try {
//         const { uid } = req.user;
//         const schema = `db${uid.replace(/[^a-zA-Z0-9_]/g, "")}`;
//         const conn = pool;

//         // 1️⃣ First update authenticated column for this loginid
//         await updateAuthenticated(uid, 1);

//         // 2️⃣ Then call API with this loginid
//         await hitApiWithLoginId("http://103.148.165.134:5005/api/Imap/IMAPInit?lid="+uid);

//         // 3️⃣ Now insert CSV results into userlist
//         for (const user of results) {
//           await conn.query(
//             `INSERT INTO ${schema}.userlist (loginid,userid, useremail, password, name, vtype) VALUES (?,?, ?, ?, ?, ?)`,
//             [uid,user.userid, user.useremail, user.password, user.name, user.vtype]
//           );
//         }

//         fs.unlinkSync(req.file.path); // cleanup temp file
//         res.json({
//           message: "CSV data inserted successfully after authentication update",
//           inserted: results.length,
//         });
//       } catch (err) {
//         console.error(err);
//         res.status(500).json({ error: "Process failed", details: err.message });
//       }
//     });
// };




const imapMultipleAccount = async (req, res) => {
  if (!req.file) {
    return res.status(400).json({ error: "CSV file is required" });
  }

  const results = [];

  fs.createReadStream(req.file.path)
    .pipe(csvParser())
    .on("data", (row) => {
      const email = row.email?.trim();
      const password = row.password?.trim();
      const name = row.display_name?.trim() || null;
      const host = row.host?.trim() || null;

      if (email && password) {
        results.push({
          userid: generateUserId(),
          useremail: email,
          password,
          name,
          host,
          vtype: 4, // IMAP
        });
      }
    })
    .on("end", async () => {
      try {
        if (results.length === 0) {
          return res.status(400).json({ error: "CSV file is empty or invalid" });
        }

        const firstUser = results[0];
console.log(firstUser )
        // 1️⃣ Verify only first email
        const isVerified = await verifyImapEmail(firstUser.useremail, firstUser.password, firstUser.host);
        if (!isVerified) {
          fs.unlinkSync(req.file.path);
          return res.status(400).json({ error: "First email verification failed" });
        }

        const { uid } = req.user;
        const schema = `db${uid}`;
        const conn = pool;

        // 2️⃣ Update authenticated column for this loginid
        await updateAuthenticated(uid, 1);

        // 3️⃣ Call API with this loginid
        await hitApiWithLoginId("http://103.148.165.134:5005/api/Imap/IMAPInit?lid=" + uid);

        // 4️⃣ Insert all CSV results (since first one passed verification)
        for (const user of results) {
          await conn.query(
            `INSERT INTO ${schema}.userlist (loginid, userid, useremail, password, name,imaphost, vtype) VALUES (?, ?, ?, ?, ?, ?,?)`,
            [uid, user.userid, user.useremail, user.password, user.name,user.host,user.vtype]
          );
        }
        const updateaccounts=await conn.query(`UPDATE useraccountos SET redirectflag=?`,[0])

        fs.unlinkSync(req.file.path); // cleanup temp file
        res.json({
          message: "CSV data inserted successfully after first email verification",
          inserted: results.length,
        });
      } catch (err) {
       log(err,"csv insertion failure")
        res.status(500).json({ error: "Process failed", details: err.message });
      }
    });
};




module.exports = { fetchUserList, 
    backupPrefrences, 
    recentBackup, 
    getMailCountByLoginId, 
    getLicenseandProductDetails, 
    onBakcupJobSubmit, 
    CheckJobCreated,
    getCollectiveBackup,
    userWiseBackupData ,
    getfiveOngoingBackup,
     FolderwiseCalendarBackupData,
     FolderwiseContactBackupData,
     FolderwiseDriveBackupData,
     FolderwiseMailBackupData,
     FolderwiseNotesBackupData,
     FolderwiseTaskBackupData,
    imapMultipleAccount
    }