const express = require('express')
const app = express()
const {pool} = require('../connection/connection')
const { log } = require('../logger/log')


const recentOngoingBackup = async (req, res) => {
    const connection = await pool
    try {

        const { uid } = req.cookies
    const schema = `db${uid}`;       
    const query = `
  SELECT 
    b.*, u.name, u.useremail 
  FROM ${schema}.userbackupmain b
  JOIN ${schema}.userlist u ON b.userid = u.id
  WHERE b.loginid = ? AND b.eflag=?
  ORDER BY b.id DESC;
`;

        const [getRecentBackup] = await connection.query(query, [uid,0])

        res.status(200).json({ data: getRecentBackup })


    }
    catch (error) {
        log(error, "ERROR")
        res.status(500).json({ message: "Internal Server Error" })


    }
 
}


module.exports={recentOngoingBackup}