const express = require('express')
const app = express()
const {pool} = require('../connection/connection')
const { log } = require('../logger/log')



const fetchListforBackupRestore = async (req, res) => {
    const connection = await pool
    try {

        const { uid } = req.user

       const query = `SELECT
       b.id,
    b.loginid,
    b.userid,
    u.useremail,
    u.name,
    b.stime,
    b.etime,
    b.mailcount,
    b.totmailcount
FROM
    db${uid}.userbackupmain b
JOIN
    db${uid}.userlist u ON b.userid = u.id
WHERE
    b.sflag = 1
    AND b.eflag = 1
    AND b.etime IS NOT NULL
    AND b.mailcount>0;`;

        const [getRecentBackup] = await connection.query(query, [uid])

        res.status(200).json({ data: getRecentBackup })


    }
    catch (error) {
        log(error, "Restore list")
        res.status(500).json({ message: "Internal Server Error" })


    }
   
}


const getDownloadbleBackup= async(req,res)=>{
    const connection = await pool
    try{

        const { uid } = req.user
 const query = `
  SELECT 
    d.id,
    d.loginid,
    u.name,
    u.useremail,
    d.stime ,
    d.eflag,
    d.filename
  FROM db${uid}.userdwndetails d
  JOIN db${uid}.userlist u ON d.userid = u.id
  WHERE d.loginid = ?
`;


const [getRecentRestoreziplist] = await connection.query(query, [uid,1,1])

        res.status(200).json( getRecentRestoreziplist)

    }
    catch(error){
        log(error,"Restore Download List Error")
        res.status(501).json({message:"Internal Server Error"})

    }
   
}



const getRuuningResotreCount= async(req,res)=>{
    const connection =pool
    try{

        const { uid } = req.user
 const query = `
  SELECT COUNT(*) AS RCount
  FROM db${uid}.userdwndetails d
  WHERE d.loginid = ? AND d.sflag=? AND d.eflag=?
`;


const [getRunningCount] = await connection.query(query, [uid,1,0])

        res.status(200).json( {count:getRunningCount[0].RCount})

    }
    catch(error){
        log(error,"Restore Download List Error")
        res.status(501).json({message:"Internal Server Error"})
    }
   
}


module.exports={fetchListforBackupRestore,getDownloadbleBackup,getRuuningResotreCount}