const express = require('express')
const app = express()
const connectToDatabase = require('../connection/connection')
const { log } = require('../logger/log')

const updateUserList = async (req, res) => {
  const connect = await connectToDatabase();
  try {
    const { uid } = req.user;
    const toUpdate = req.body.users;

    if (!Array.isArray(toUpdate) || toUpdate.length === 0) {
      return res.status(400).json({ success: false, message: 'No users to update' });
    }

    const query = `UPDATE db${uid}.userlist SET selected = ? WHERE id = ?`;

    for (const user of toUpdate) {
      const { userid, selected } = user;
      await connect.execute(query, [selected, userid]);
    }

    return res.status(200).json({ success: true, message: 'Users updated successfully' });
  } catch (error) {
    console.error('Error updating user list:', error);
    return res.status(500).json({ success: false, message: 'Internal Server Error' });
  }
};


const updateUserPreference = async (req, res) => {
  const db = await connectToDatabase();

  try {
    const { uid } = req.user;
    const { frequency, email, con, cal, task, note } = req.body;

    if (!uid) {
      return res.status(400).json({ message: "UID not found in cookies" });
    }

    const schema = `db${uid}`;
    const query = `
      UPDATE ${schema}.usermailsettings 
      SET frequency = ?, email = ?, con = ?, cal = ?, task = ?, note = ?
    `;

    await db.query(query, [frequency, email, con, cal, task, note]);

    res.status(200).json({ message: "Preferences updated successfully" });
  } catch (error) {
    log(error, "updateUserPreference");
    res.status(500).json({ message: "Error updating preferences" });
  }
};



module.exports={updateUserList,updateUserPreference}