const jwt = require("jsonwebtoken");
require('dotenv').config()
// Your secret key
const SECRET_KEY = 'asdgj-sm34m-q4gf3-qj124-ak262';

// Middleware function
function validUser(req, res, next) {
  // Get token from headers (common pattern: Authorization: Bearer <token>)
  const authHeader = req.headers["authorization"];
  if (!authHeader) {
    return res.status(401).json({ message: "No token provided" });
  }

  const token = authHeader.split(" ")[1]; // Bearer <token>

  if (!token) {
    return res.status(401).json({ message: "Token missing" });
  }

  // Verify token
  jwt.verify(token, SECRET_KEY, (err, decoded) => {
    if (err) {
      return res.status(403).json({ message: "Invalid or expired token" });
    }

    // Token is valid, attach decoded payload to request
    req.user = decoded;
    next(); // pass control to the next middleware/route handler
  });
}

module.exports = validUser;
