const transporter = require('./transporter');

async function sendVerificationEmail(userEmail, userName, token) {
  const verificationLink = `http://103.139.58.182/verify/${token}`;

  const htmlContent = `
  <div style="max-width: 600px; margin: auto; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; border: 1px solid #e0e0e0; border-radius: 10px; padding: 30px; background-color: #f9f9f9;">
    <div style="text-align: center; margin-bottom: 30px;">
      <h2 style="color: #2d3748;">🌥️ CloudBackup</h2>
      <p style="font-size: 18px; color: #4a5568;">Secure. Reliable. Yours.</p>
    </div>

    <div style="background-color: #ffffff; padding: 20px; border-radius: 8px;">
      <h3 style="color: #2d3748;">Hello ${userName || 'User'},</h3>
      <p style="font-size: 16px; color: #4a5568;">
        Thank you for signing up for <strong>CloudBackup</strong>. To complete your registration and verify your email address, please click the button below:
      </p>

      <div style="text-align: center; margin: 30px 0;">
        <a href="${verificationLink}" style="background-color: #3182ce; color: white; text-decoration: none; padding: 12px 24px; border-radius: 6px; font-weight: bold;">
          Verify Email
        </a>
      </div>

      <p style="font-size: 14px; color: #718096;">
        If you did not create an account with CloudBackup, you can safely ignore this email.
      </p>

      <p style="font-size: 14px; color: #a0aec0; margin-top: 40px;">— The CloudBackup Team</p>
    </div>

    <div style="text-align: center; font-size: 12px; color: #a0aec0; margin-top: 30px;">
      &copy; ${new Date().getFullYear()} CloudBackup. All rights reserved.
    </div>
  </div>
  `;

  try {
    const info = await transporter.sendMail({
      from: '"CloudBackup" <companyemail@gmail.com>',
      to: userEmail,
      subject: 'Verify your email - CloudBackup',
      html: htmlContent,
    });

    console.log(`✔️ Email sent to ${userEmail}: ${info.messageId}`);
    return {
      success: true,
      message: `Email sent to ${userEmail}`,
      messageId: info.messageId,
    };
  } catch (error) {
    console.error(`❌ Failed to send email to ${userEmail}:`, error);
    return {
      success: false,
      message: `Failed to send email to ${userEmail}`,
      error: error.message,
    };
  }
}


module.exports = sendVerificationEmail;
