const moment = require('moment');


async function getAverageDuration(timePairs) {
  if (!Array.isArray(timePairs) || timePairs.length === 0) return "00:00:00";

  let totalDuration = 0;

  timePairs.forEach(({ stime, etime }) => {
    const start = moment(stime);
    const end = moment(etime);
    if (start.isValid() && end.isValid()) {
      totalDuration += end.diff(start);
    }
  });

  const avgDurationMs = totalDuration / timePairs.length;
  return moment.utc(avgDurationMs).format("HH:mm:ss");
}



module.exports=getAverageDuration