const express = require('express')
const app = express()
const {pool} = require('../connection/connection')
const { log } = require('../logger/log')
const avgTimeCalculator=require('../utils/timeAverage')




// const getAdmintypeStats= async (req,res)=>{
//     const db= await pool
//     try{
//         const { uid } = req.user
        
//         const  query=`SELECT 
//         db${uid}.userbackupmain.stime,
//         db${uid}.userbackupmain.etime,
//         db${uid}.userbackupmain.mailcount
//         FROM db${uid}.userbackupmain 
//         WHERE loginid=? AND eflag=?`


// const query2 = `
//   SELECT 
//     product.productname
//   FROM product
//   LEFT JOIN license ON license.productid = product.id 
//   WHERE license.loginid = ?
//   GROUP BY product.productname
// `;


// const query3=`SELECT COUNT(db${uid}.userbackupmain.id) AS Queued FROM db${uid}.userbackupmain WHERE db${uid}.userbackupmain.loginid = ? AND db${uid}.userbackupmain.eflag = ?`



//         const [execute]=await db.query(query,[uid,1])
//         const [execute2]=await db.query(query2,[uid])
//         const [execute3]=await db.query(query3,[uid,0])
//         const avgTime= await avgTimeCalculator(execute)
//       const totalmails= execute.reduce((sum, row) => sum + Number(row.mailcount), 0);
      

//      res.status(200).json({avgBackupTime:avgTime,totalEmails:totalmails,prodName:execute2[0].productname,queuedJobs:execute3[0].Queued})

//   // console.log(execute)
//     }
//     catch(error){
//         res.status(500).json({msg:"Internal Server Error"})
//     log(error,"Error")
//     }
//     finally{
//         db.end()
//     }
// }




const getAdmintypeStats = async (req, res) => {
  const db = await pool;
  try {
    const { uid } = req.user;

    const query = `SELECT 
        db${uid}.userbackupmain.stime,
        db${uid}.userbackupmain.etime,
        db${uid}.userbackupmain.mailcount
        FROM db${uid}.userbackupmain 
        WHERE loginid=? AND eflag=?`;

    const query2 = `
      SELECT 
        product.productname
      FROM product
      LEFT JOIN license ON license.productid = product.id 
      WHERE license.loginid = ?
      GROUP BY product.productname
    `;

    const query3 = `SELECT COUNT(db${uid}.userbackupmain.id) AS Queued 
                    FROM db${uid}.userbackupmain 
                    WHERE db${uid}.userbackupmain.loginid = ? AND db${uid}.userbackupmain.eflag = ?`;

    let execute, execute2, execute3;

    try {
      [execute2] = await db.query(query2, [uid]);
      [execute] = await db.query(query, [uid, 1]);
      [execute3] = await db.query(query3, [uid, 0]);
    } catch (dbErr) {
      // If DB doesn't exist or table is missing, return dummy data
      return res.status(200).json({
        avgBackupTime: "0 mins",
        totalEmails: 0,
        prodName: execute2[0]?.productname,
        queuedJobs: 0
      });
    }

    const avgTime = await avgTimeCalculator(execute);
    const totalmails = execute.reduce((sum, row) => sum + Number(row.mailcount), 0);

    res.status(200).json({
      avgBackupTime: avgTime,
      totalEmails: totalmails,
      prodName: execute2[0]?.productname || "Unknown",
      queuedJobs: execute3[0]?.Queued || 0
    });

  } catch (error) {
    res.status(500).json({ msg: "Internal Server Error" });
    log(error, "Error");
  } 
};





// const getStatsforChart = async (req, res) => {
//   const db = await pool;
//   try {
//     const { uid } = req.user;

//     const query = `
//       SELECT 
//         COUNT(*) AS totalUsers,
//         SUM(CASE WHEN db${uid}.userlist.selected = 1 THEN 1 ELSE 0 END) AS protectedUsers,
//         SUM(CASE WHEN db${uid}.userlist.selected = 0 THEN 1 ELSE 0 END) AS unprotectedUsers
//       FROM db${uid}.userlist;
//     `;

//     const [rows] = await db.query(query);
//     res.status(200).json(rows[0]); // rows[0] has the result object
//   } catch (error) {
//     log(error, "Error Stats Chart");
//     res.status(500).json({ error: "Internal Server Error" });
//   } finally {
//     db.end();
//   }
// };

const getStatsforChart = async (req, res) => {
  const db = await pool;
  try {
    const { uid } = req.user;

    const query = `
      SELECT 
        COUNT(*) AS totalUsers,
        SUM(CASE WHEN db${uid}.userlist.selected = 1 THEN 1 ELSE 0 END) AS protectedUsers,
        SUM(CASE WHEN db${uid}.userlist.selected = 0 THEN 1 ELSE 0 END) AS unprotectedUsers
      FROM db${uid}.userlist;
    `;

    let rows;

    try {
      [rows] = await db.query(query);
    } catch (dbErr) {
      // Database or table might not exist – fallback to dummy data
      return res.status(200).json({
        totalUsers: 0,
        protectedUsers: 0,
        unprotectedUsers: 0
      });
    }

    res.status(200).json(rows[0]); // rows[0] contains result object

  } catch (error) {
    log(error, "Error Stats Chart");
    res.status(500).json({ error: "Internal Server Error" });
  } 
};


const userPreference = async (req, res) => {
  const db = await pool;

  try {
    const { uid } = req.user;

    if (!uid) {
      return res.status(400).json({ message: "UID not found in cookies" });
    }

    // Sanitize the schema name to prevent SQL injection
    const schema = `db${uid}`;

    // Dynamic table/schema name must be directly injected (can't use ? placeholder)
    const query = `SELECT * FROM ${schema}.usermailsettings`;

    const [fetchData] = await db.query(query);
    res.status(200).json({ data: fetchData });
  } catch (error) {
    log(error, "user Preference");
    res.status(501).json({ message: "Some error occurred" });
  }
};



const checkUserBackupExists = async (req, res) => {
  const {uid } = req.user;

  try {
    const [rows] = await pool.query(
      `SELECT 1 FROM db${uid}.userbackupmain WHERE loginid = ? LIMIT 1`,
      [uid]
    );

    if (rows.length > 0) {
      return res.json({ exists: true });
    } else {
      return res.json({ exists: false });
    }
  } catch (error) {
    console.error('Database error:', error);
    res.status(500).json({ error: 'Internal Server Error' });
  }
};


module.exports={getAdmintypeStats,getStatsforChart,userPreference,checkUserBackupExists}