const express= require('express')
const router=express.Router()
const multer = require("multer");
const verifier=require("../middleware/verifyJWT")
const {fetchUserList, backupPrefrences, 
    recentBackup, getMailCountByLoginId, 
    getLicenseandProductDetails, onBakcupJobSubmit, 
    CheckJobCreated, getCollectiveBackup, 
    userWiseBackupData, getfiveOngoingBackup, 
    FolderwiseBackupData,
    FolderwiseMailBackupData,
    FolderwiseCalendarBackupData,
    FolderwiseTaskBackupData,
    FolderwiseNotesBackupData,
    FolderwiseDriveBackupData,
    FolderwiseContactBackupData,
imapMultipleAccount}=require('../controller/backupAccountController')



const upload = multer({ dest: "uploads/" });

router.get('/fetchUserListAdmin',verifier,fetchUserList)
router.post('/setBackupPref',verifier,backupPrefrences)
router.get('/recentbackupfetch',verifier,recentBackup)
router.get('/getCollectiveBackup',verifier,getCollectiveBackup)
router.get('/userWiseDatafetch',verifier,userWiseBackupData)
router.get('/totalMailCount',verifier,getMailCountByLoginId)
router.get('/getReqiuredDetails',verifier,getLicenseandProductDetails)
router.post('/submitbackupstart',verifier,onBakcupJobSubmit)
router.get('/fetchJobcreation',verifier,CheckJobCreated)
router.get('/recentOngoingBackup',verifier,getfiveOngoingBackup)
router.get('/fetchbackupFolders',verifier,FolderwiseMailBackupData)
router.get('/fetchTaskFolders',verifier,FolderwiseTaskBackupData)
router.get('/fetchNotesFolders',verifier,FolderwiseNotesBackupData)
router.get('/fetchDriveFolders',verifier,FolderwiseDriveBackupData)
router.get('/fetchCalendarFolders',verifier,FolderwiseCalendarBackupData)
router.get('/fetchContactFolders',verifier,FolderwiseContactBackupData)



router.post("/imapMultiAccount",verifier, upload.single("csvFile"), imapMultipleAccount);

module.exports=router